import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import MonitoraggioSpecieForm from "../../../../core/Forms/MonitoraggioSpecieForm/MonitoraggioSpecieForm";
import {monitoraggioSpecieQuery} from "../../../../api/queries";
import {Button, Card, CardBody, CardText, CardTitle} from "reactstrap";
import AcquaticaDrop from "../../../../core/AcquaticaDrop";
import Loading from "../../../../core/Loading/Loading";
import moment from 'moment';
import 'moment/locale/it';
import {findById} from "../../../../utils";
import ReactTable from "react-table";
import Ionicon from "react-ionicons";

class Detail extends Component {

    constructor(props) {
        super(props);

        this.state = {
            submitting: false,
            error: false,
        };
    }

    componentWillMount() {
        moment.locale("it");
    }

    render() {
        const {data} = this.props;

        if(data.loading) {
            return(<Loading/>);
        }

        const {
            monitoraggioSpecie,
            specieProgettos
        } = data;

        const specieProgetto = findById(specieProgettos, monitoraggioSpecie.specie.id);

        return (<div className="container" style={{marginBottom: '20px'}}>
            <div className="row">
                <div className="col">
                    <div className="form-group">
                        <label htmlFor="specie">Specie</label>
                        <Card>
                            <CardBody style={{backgroundColor: "#ffffff"}}>
                                {monitoraggioSpecie.specie && <CardTitle className="ionicon-center">
				    <img src={'/LifeEremitaWeb/specie/'+monitoraggioSpecie.specie.id+'.png'} style={{'marginRight':'2em'}} />
                                    {monitoraggioSpecie.specie.denominazioneTaxon}
                                    {<AcquaticaDrop containerStyle={{marginLeft: '0.2em'}} acquatica={specieProgetto.acquatica} specieId={specieProgetto.id}/>}
                                </CardTitle>}

                                {!monitoraggioSpecie.specie && <CardText>
                                    Specie non indicata
                                </CardText>}
                            </CardBody>
                        </Card>
                    </div>
                </div>
            </div>
            <div>
                <div className="row">
                    <div className="col">
                        <h5>Informazioni Generali</h5>
                    </div>
                </div>
                <dl className="row">
                    <dt className="col-sm-3">
                        ID Scheda
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.idScheda}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Sito Natura 2000
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.sitoNatura2000 && monitoraggioSpecie.sitoNatura2000.nome}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Rilevatore/i
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.rilevatori}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Data e Ora Inizio Rilievo
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.inizioRilievo && moment(monitoraggioSpecie.inizioRilievo).format("LLLL")}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Data e Ora Fine Rilievo
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.fineRilievo && moment(monitoraggioSpecie.fineRilievo).format("LLLL")}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Transetto
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.transetto}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Condizioni Meteo Inizio Rilievo
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.meteoInizio && monitoraggioSpecie.meteoInizio.etichetta}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Condizioni Meteo Fine Rilievo
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.meteoFine && monitoraggioSpecie.meteoFine.etichetta}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Temperatura dell'aria
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.temperaturaAria}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Umidità Relativa
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.umiditaRelativa}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Velocità/direzione vento
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.vento}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Tipologia Monitoraggio
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.tipologiaMonitoraggio && monitoraggioSpecie.tipologiaMonitoraggio.etichetta}
                    </dd>
                </dl>


                <div>
                    <div className="row">
                        <div className="col">
                            <h5>Altre Informazioni</h5>
                        </div>
                    </div>
                </div>

                {specieProgetto.acquatica == "true" && <div>
                    <dl className="row">
                        <dt className="col-sm-3">
                            Profondità Minima Acqua
                        </dt>
                        <dd className="col-sm-9">
                            {monitoraggioSpecie.profonditaMinAcqua}
                        </dd>
                    </dl>
                    <dl className="row">
                        <dt className="col-sm-3">
                            Profondità Massima Acqua
                        </dt>
                        <dd className="col-sm-9">
                            {monitoraggioSpecie.profonditaMaxAcqua}
                        </dd>
                    </dl>

                    <dl className="row">
                        <dt className="col-sm-3">
                            pH
                        </dt>
                        <dd className="col-sm-9">
                            {monitoraggioSpecie.pH}
                        </dd>
                    </dl>

                    <dl className="row">
                        <dt className="col-sm-3">
                            Conducibilità Acqua
                        </dt>
                        <dd className="col-sm-9">
                            {monitoraggioSpecie.conducibilita}
                        </dd>
                    </dl>

                    <dl className="row">
                        <dt className="col-sm-3">
                            Limpidezza Acqua
                        </dt>
                        <dd className="col-sm-9">
                            {monitoraggioSpecie.limpidezza && monitoraggioSpecie.limpidezza.etichetta}
                        </dd>
                    </dl>

                    <dl className="row">
                        <dt className="col-sm-3">
                            Visibilità Acqua
                        </dt>
                        <dd className="col-sm-9">
                            {monitoraggioSpecie.visibilitaAcqua}
                        </dd>
                    </dl>

                    <dl className="row">
                        <dt className="col-sm-3">
                            Temperatura Acqua Inizio Transetto
                        </dt>
                        <dd className="col-sm-9">
                            {monitoraggioSpecie.temperaturaAcquaInizioTransetto}
                        </dd>
                    </dl>

                    <dl className="row">
                        <dt className="col-sm-3">
                            Temperatura Acqua Fine Transetto
                        </dt>
                        <dd className="col-sm-9">
                            {monitoraggioSpecie.temperaturaAcquaFineTransetto}
                        </dd>
                    </dl>
                </div>}

                <dl className="row">
                    <dt className="col-sm-3">
                        Note
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioSpecie.note}
                    </dd>
                </dl>

                <div className="row">
                    <div className="col">
                        <h5>Allegati al Monitoraggio</h5>
                    </div>
                </div>

                <ReactTable
                    loading={data.loading}
                    noDataText={"Nessun documento presente"}
                    className="-highlight"
                    data={data.monitoraggioSpecie.documenti}
                    style={{}}
                    defaultPageSize={100}
		    minRows={3}
		    showPagination={false}
                    nextText="Avanti"
                    previousText="Indietro"
                    loadingText="Caricamento in corso..."
                    rowsText="elementi"
                    ofText="di"
                    pageText="Pagina"
                    columns={[

                        {
                            Header: "Nome File",
                            accessor: "nomeFile",
                        },
			   {
			     Header: "Scarica",
		  	     Cell: (row) => (
				      <div style={{display: 'flex', alignItems: 'center'}}>
            				  <div className="btn-group btn-group-sm" style={{margin: '0 auto'}}>
            				    <Button className="btn ionicon-btn btn-light" onClick={() => window.open('/LifeEremitaWeb/download/'+row.original.uuid)}>
          				        <Ionicon icon="ios-download-outline" />
          				      </Button>
           				   </div>
         			     </div>
			     )
			   }
                    ]} />

                <div className="row">
                    <div className="col">
                        <h5>Rilievi</h5>
                    </div>
                </div>

                <ReactTable
                    loading={data.loading}
                    noDataText={"Nessun rilievo presente"}
                    className="-highlight"
                    data={data.monitoraggioSpecie.segnalazioni}
                    style={{}}
          		defaultPageSize={100}
	  		minRows={3}
	  		showPagination={false}
                    nextText="Avanti"
                    previousText="Indietro"
                    loadingText="Caricamento in corso..."
                    rowsText="elementi"
                    ofText="di"
                    pageText="Pagina"
                    columns={[
                       {
         		 Header: "ID Habitat",
          		 accessor: "idHabitat",
         		 width: 200,
        		},
			 {
         		 Header: "Lon",
          		 accessor: "coordinataX",
         		 width: 70,
        		},
			    {
         		 Header: "Lat",
          		 accessor: "coordinataY",
         		 width: 70,
        		},
                        {
                            Header: "Esemplari",
                            columns: [
                                {
				    width:50,
                                    Header: "M",
                                    accessor: "esemplariM",
				    style: {'text-align':'center'}
                                },
                                {
				    width:50,
                                    Header: "F",
                                    accessor: "esemplariF",
				    style: {'text-align':'center'}
                                },
                                {
				    width:50,
                                    Header: "MF",
                                    accessor: "esemplariMF",
				    style: {'text-align':'center'}
                                }
                            ]
                        },
                        {
                            Header: "Stadio Sviluppo",
                            accessor: "stadioSviluppo.etichetta",
			    width:140
                        },
                        {
                            Header: "Note",
                            accessor: "note",
                        }
                    ]} />

                <div className="row">
                    <div className="col">
                        <h5>Segnalazioni Altre Specie</h5>
                    </div>
                </div>

                <ReactTable
                    loading={data.loading}
                    noDataText={"Nessuna Segnalazione Presente"}
                    className="-highlight"
                    data={data.monitoraggioSpecie.segnalazioniAltreSpecie}
                    style={{}}
          		defaultPageSize={100}
	  		minRows={3}
	  		showPagination={false}
                    nextText="Avanti"
                    previousText="Indietro"
                    loadingText="Caricamento in corso..."
                    rowsText="elementi"
                    ofText="di"
                    pageText="Pagina"
                    columns={[
                        /*{
                            Header: "ID",
                            accessor: "id",
                            width: 50,
                        },*/
                        {
                            Header: "Specie",
                            accessor: "specie.nomeMenu",
                        },
                        {
                            Header: "Esemplari",

                            columns: [
                                {
				    width:50,
                                    Header: "M",
                                    accessor: "esemplariM",
				    style: {'text-align':'center'}
                                },
                                {
				    width:50,
                                    Header: "F",
                                    accessor: "esemplariF",
				    style: {'text-align':'center'}
                                },
                                {
				    width:50,
                                    Header: "MF",
                                    accessor: "esemplariMF",
				    style: {'text-align':'center'}
                                }
                            ]
                        },
                        {
                            Header: "Note",
                            accessor: "note",
                        }
                    ]} />
            </div>
        </div>);
    }
}

export default compose(
    graphql(monitoraggioSpecieQuery, {
        options:({match}) => ({variables: {id: match.params.id}}),
    }),
)(Detail);

Detail.defaultProps = {};

Detail.propTypes = {};
